/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef _mx_arch_h_
#define _mx_arch_h_

#include <sys/param.h>
#include <sys/conf.h>
#include <sys/kernel.h>
#include <sys/systm.h>
#if __FreeBSD_version < 502122
#define kdb_enter Debugger
#define kdb_backtrace backtrace 
#else
#include <sys/kdb.h>
#endif
#include <sys/lock.h>
#include <sys/types.h>
#include <sys/malloc.h>
#include <sys/mutex.h>
#include <sys/condvar.h>
#include <sys/proc.h>
#include <sys/vnode.h>                  /* for VCHR */
#include <sys/kthread.h>
#include <sys/sf_buf.h>

#include <machine/stdarg.h>
#include <sys/limits.h>

#include <vm/vm.h>
#include <vm/vm_param.h>
#include <vm/vm_kern.h>
#include <vm/vm_object.h>
#include <vm/vm_page.h>
#include <vm/vm_pageout.h>
#include <vm/vm_pager.h>
#include <vm/vm_extern.h>
#include <vm/uma.h>
#include <vm/uma_int.h>

#include <vm/vm_object.h>
#include <vm/vm_page.h>
#include <vm/vm_pageout.h>              /* for vm_page_max_wired */
#include <vm/vm_map.h>                  /* for vm_map type */
#include <sys/proc.h>                   /* for process struct */
#include <sys/endian.h>

#include <sys/module.h>
#include <sys/bus.h>
#include <machine/bus.h>
#include <sys/rman.h>
#include <machine/resource.h>
#include <machine/stdarg.h>

#include "mx_auto_config.h"
#include "mx_int.h"
#include "mx_io_impl.h"
#include "mcp_config.h"
#include "mcp_global.h"
#include "myriexpress.h"

#define MX_PRINT(s) printf s
#define MX_WARN(s) do {                 \
  printf("mx WARN: ");                  \
  printf s;                             \
} while (0)

#define MX_INFO(s) do {                 \
  printf("mx INFO: ");                  \
  printf s;                             \
} while (0)

#include "mx_debug.h"
#include "mx_pci.h"

typedef struct mx_arch_instance_info
{
  device_t dev;                   /* newbus device handle */
  char  *csr;                     /* control/status registers */
  struct resource *mem;           /* resource descriptor for registers */
  struct resource *irq;           /* resource descriptor for interrupt */
  void *ih;                       /* interrupt handler cookie */
  int inuse;                      /* count of users*/
  dev_t user_dev;
  dev_t priv_dev;
} mx_arch_instance_info_t;

typedef struct mx_arch_endpt_info
{
  struct proc* proc;
} mx_arch_endpt_info_t;


#define MX_MTX_STRLEN 64

typedef struct
{
  int wake_cnt;
  struct mtx sleep_mtx;
  struct mtx mtx;
  struct cv cv;
  char mtx_string[MX_MTX_STRLEN];
  char sleep_mtx_string[MX_MTX_STRLEN];
} mx_sync_t;

typedef struct mtx mx_spinlock_t;

struct mx_page_pin
{
  mcp_dma_addr_t dma;
  uint64_t va;
  struct vm_page *page;
};

#define MX_OPTIMIZED_DMA_PAGE_ALLOC 1

#define mx_alloc_copyblock mx_common_alloc_copyblock
#define mx_free_copyblock mx_common_free_copyblock

/* FreeBSD normalizations */

#ifndef MIN
#define MIN(a,b) (((a)<(b))?(a):(b))
#endif

#ifndef MAX
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif

#define mx_arch_copyin(x, y, z) copyin((const void *)(x), (y), (z))
#define mx_arch_copyout(x, y, z) copyout((x), (void *)(y), (z))
#define mx_spin(x) DELAY(x)

/* 64-bit byteswapping, in case we need it */
#define mx_hton_u64(x) htobe64(x)
#define mx_ntoh_u64(x) be64toh(x)

/* atomic types and operations */
typedef volatile uint32_t mx_atomic_t;
#define mx_atomic_add(value, ptr)       atomic_add_int(ptr, value)
#define mx_atomic_subtract(value, ptr)  atomic_subtract_int(ptr, value)
#define mx_atomic_read(ptr)             atomic_load_acq_int(ptr)
#define mx_atomic_set(ptr, value)       atomic_store_rel_int(ptr, value)

/* spinlocks */
#define mx_spin_lock(lock)    mtx_lock_spin(lock)
#define mx_spin_unlock(lock)  mtx_unlock_spin(lock)
#define mx_spin_lock_irqsave(lock, flags) mtx_lock_spin(lock)
#define mx_spin_unlock_irqrestore(lock, flags) mtx_unlock_spin(lock)

/* mutex operations.  Macros so that the FreeBSD lock
   debugging code can figure out what line of code the mutex was taken
   on */

#define mx_mutex_enter(s)  mtx_lock(&(s)->mtx)
#define mx_mutex_exit(s)   mtx_unlock(&(s)->mtx)

#define mx_reserve_page(x)
#define mx_unreserve_page(x)

#ifndef M_WAITOK
#define M_WAITOK 0
#endif

#define MX_MZERO    M_ZERO
#define MX_WAITOK   M_WAITOK
#define MX_NOWAIT   M_NOWAIT

#define MOD_INC_USE_COUNT atomic_add_int(&mx_use_count, 1)
#define MOD_DEC_USE_COUNT atomic_subtract_int(&mx_use_count, 1)

#define mx_kgetpid() ((uint32_t)curproc->p_pid)

#define mx_get_memory_context() 0

#if (__FreeBSD_version > 600033 && __FreeBSD_version < 700000) || (__FreeBSD_version > 700001)
#define MX_FREEBSD_CLONE_TAKES_UCRED 1
#else
#define MX_FREEBSD_CLONE_TAKES_UCRED 0
#endif


#endif /* _mx_arch_h_ */
